setwd("<your directory or folder path>")

df1 <- read.csv("20191121 Example 17.2 Cox Proportional Hazards Data.csv")
#
#
#  Need library(survival) for this code to work
#  only needs to run once in a session
library(survival) 
#

# VARIABLES:
# 
# Group
# Unit
# Time
# Censor
#
attach(df1)

surv.obj <- Surv(time=Time,event=Censor)

#cox.model <- coxph(formula = surv.obj ~ factor(Group)+ factor(Unit)%in%factor(Group),data=df1)
cox.model <- coxph(formula = surv.obj ~ factor(Group),data=df1)

summary(cox.model)
#
# To get predicted survival curves:
#
x.pred <- exp(-predict(cox.model,type="expected"))
g1.pred <- x.pred[Group==1]
g2.pred <- x.pred[Group==2]
g3.pred <- x.pred[Group==3]
g1.time <- Time[Group==1]
g2.time <- Time[Group==2]
g3.time <- Time[Group==3]
plot(x=g1.time,y=g1.pred,pch=1,col="blue",type="p",main="Survival Probabilities by Group",xlim=c(0,35),ylim=c(0.0,1.0),xlab="t=Time-to-Event",ylab="Pr{T >= t}")
points(x=g2.time,y=g2.pred,pch=2,col="red")
points(x=g3.time,y=g3.pred,pch=3,col="orange")
legend(x=27,y=0.85,legend=c("Group 1","Group 2","Group 3"),pch=c(1,2,3),col=c("blue","red","orange"))
